#
# Test engine native conflict resolution for ndb
#   NDB$EPOCH() function
#
#
--source include/have_ndb.inc
--source include/have_binlog_format_mixed_or_row.inc
--source suite/ndb_rpl/ndb_master-slave.inc

--echo Setup circular replication

--connection slave
RESET MASTER;
select @slave_server_id:=(variable_value+0)
       from information_schema.global_variables
       where variable_name like 'server_id';
let $SLAVE_SERVER_ID= query_get_value('select @slave_server_id as v',v,1);

--connection master
--replace_result $SLAVE_MYPORT SLAVE_PORT
--eval CHANGE MASTER TO master_host="127.0.0.1",master_port=$SLAVE_MYPORT,master_user="root"
START SLAVE;
select @master_server_id:=(variable_value+0)
       from information_schema.global_variables
       where variable_name like 'server_id';
let $MASTER_SERVER_ID= query_get_value('select @master_server_id as v',v,1);

--echo Setup ndb_replication and t1$EX exceptions table

--disable_warnings
--disable_query_log
--connection master
drop table if exists mysql.ndb_replication;
CREATE TABLE mysql.ndb_replication
  (db VARBINARY(63),
   table_name VARBINARY(63),
   server_id INT UNSIGNED,
   binlog_type INT UNSIGNED,
   conflict_fn VARBINARY(128),
   PRIMARY KEY USING HASH (db,table_name,server_id))
  ENGINE=NDB PARTITION BY KEY(db,table_name);
--enable_warnings
--enable_query_log

--echo Populate ndb_replication table as necessary
--echo -- 0 extra gci bits
eval replace into mysql.ndb_replication values
  ("test", "t1", $SLAVE_SERVER_ID, 7, NULL),
  ("test", "t1", $MASTER_SERVER_ID, 7, "NDB\$EPOCH(0)");

--source suite/ndb_rpl/t/ndb_rpl_conflict_epoch_1.inc

--echo Populate ndb_replication table as necessary
--echo -- 1 extra gci bits
eval replace into mysql.ndb_replication values
  ("test", "t1", $SLAVE_SERVER_ID, 7, NULL),
  ("test", "t1", $MASTER_SERVER_ID, 7, "NDB\$EPOCH(1)");

--source suite/ndb_rpl/t/ndb_rpl_conflict_epoch_1.inc

--echo Populate ndb_replication table as necessary
--echo -- 31 extra gci bits
eval replace into mysql.ndb_replication values
  ("test", "t1", $SLAVE_SERVER_ID, 7, NULL),
  ("test", "t1", $MASTER_SERVER_ID, 7, "NDB\$EPOCH(31)");

--source suite/ndb_rpl/t/ndb_rpl_conflict_epoch_1.inc

--echo Populate ndb_replication table as necessary
--echo -- Default extra Gci bits
eval replace into mysql.ndb_replication values
  ("test", "t1", $SLAVE_SERVER_ID, 7, NULL),
  ("test", "t1", $MASTER_SERVER_ID, 7, "NDB\$EPOCH()");

--source suite/ndb_rpl/t/ndb_rpl_conflict_epoch_1.inc

--source suite/ndb_rpl/t/ndb_conflict_info_init.inc

--echo Now test batched conflict detection/handling
--connection master

create table test.t1 (
  a int primary key,
  b int,
  c varchar(2000)) engine=ndb;

--sync_slave_with_master slave
--connection slave
--echo -- Stop replication from Primary -> Secondary
stop slave;
--connection master
--echo -- Insert a row on Primary
insert into test.t1 values (1,1,repeat('B', 2000));

--connection slave
--echo -- Generate a large batch of inserts with early + late conflicts
delimiter %;

create procedure test.doit (rows int)
begin
  set @x = 0;
  START TRANSACTION;
    repeat
      insert into test.t1 values (@x, @x, repeat('B', 2000));
      set @x = @x + 1;
    until @x = rows
    end repeat;
  COMMIT;
  START TRANSACTION;
    update test.t1 set b=999, c=repeat('E',2000) where a=1;
  COMMIT;
  START TRANSACTION;
    delete from test.t1 where a=1;
  COMMIT;
  START TRANSACTION;
    insert into test.t1 values (1,1,'A');
  COMMIT;
end%

delimiter ;%

call test.doit(100);

drop procedure test.doit;

--sync_slave_with_master master
--connection master

--echo -- Look at Primary status, expect 4 conflicts
--source suite/ndb_rpl/t/ndb_conflict_info.inc

--connection slave
start slave;

--connection master
--echo -- Look at Seconday row
select a,b,sha1(c) from test.t1 where a=1;

--sync_slave_with_master slave
--echo -- Check it's the same on the Secondary
select a,b,sha1(c) from test.t1 where a=1;

--connection master
--echo Test batching of DELETE vs DELETE with following INSERT
--connection master
delete from test.t1;
insert into test.t1 values (1, 1, "Ma Brows");
--sync_slave_with_master slave
--connection slave
--sync_slave_with_master master
--connection master
--echo -- Stop Slave in both directions
stop slave;
--connection slave
stop slave;
--connection master
--echo -- Delete row on Primary Cluster
delete from test.t1 where a=1;

--connection slave
--echo -- Delete row on Secondary Cluster, followed by Insert in later 'batch'
delimiter %;

create procedure test.doit (rows int)
begin
  set @x = 2;
  START TRANSACTION;
    delete from test.t1 where a=1;
    repeat
      insert into test.t1 values (@x, @x, repeat('B', 2000));
      set @x = @x + 1;
    until @x = (rows + 2)
    end repeat;
  COMMIT;
  START TRANSACTION;
    insert into test.t1 values (1, 1, 'Malleny arms');
  COMMIT;
end%

delimiter ;%

call test.doit(200);

--echo -- Restart slave on Primary Cluster
--connection master
# TODO : Reenable with new slave counts
#--source suite/ndb_rpl/include/ndb_init_slave_counts.inc
start slave;

--connection slave
--sync_slave_with_master master

--connection master
# TODO : Reenable with new slave counts
#--disable_result_log
# Don't include results as they vary depending on epoch boundaries
#--source suite/ndb_rpl/include/ndb_slave_counts.inc
#--enable_result_log
#--echo -- Verify that batching occurred when replicating the above
#select (@ndb_slave_execute_count - @ndb_slave_commit_count) > 1;
--echo -- Show data on Primary Cluster (should have row inserted on Secondary)
select * from test.t1 where a=1;

--echo -- Show data on Secondary Cluster (should have row inserted on Secondary)
--connection slave
select * from test.t1 where a=1;

--echo --Restart slave on Secondary Cluster
start slave;
--connection master
--sync_slave_with_master slave
--connection slave

--echo -- Show data on Secondary Cluster (should now be missing)
--echo    Clusters are diverged as expected with delete vs delete conflict
--echo    followed closely by Insert
--connection slave
select * from test.t1 where a=1;

--echo -- Force wait for master to be in-sync with slave
--echo    To avoid race between DML and table drop
flush logs;
--sync_slave_with_master master

--connection master
drop procedure test.doit;
drop table test.t1;

delete from mysql.ndb_replication;
insert into mysql.ndb_replication values
  ("test", "t3", 0, 7, "NDB\$EPOCH(32)"),
  ("test", "t4", 0, 7, "NDB\$EPOCH(-1)");

--disable_query_log
# Only need suppress here, as table creation fails due to this.
call mtr.add_suppression("NDB Slave: .* Too many extra Gci bits at .*");
--enable_query_log

--error 1296 
create table test.t3 (a int primary key) engine=ndb;
show warnings;

--error 1296 
create table test.t4 (a int primary key) engine=ndb;
show warnings;

--echo -- Force sync before dropping table to avoid race
--connection master
flush logs;
--sync_slave_with_master slave
--connection slave
flush logs;
--sync_slave_with_master master

--connection master
drop table mysql.ndb_replication;

--sync_slave_with_master slave

--echo -- Attempt to get system back in pre-test state
--connection master
stop slave;
reset slave;

--source include/rpl_end.inc
