--source include/have_innodb.inc
--source include/not_embedded.inc

eval SET GLOBAL innodb_file_per_table=$file_per_table;
eval SET GLOBAL innodb_file_format=$file_format;

#
# This test is the same as innodb_gis_rollback
#

eval CREATE TABLE t1 (
  id bigint(12) unsigned NOT NULL auto_increment,
  c2 varchar(15) collate utf8_bin DEFAULT NULL,
  c1 varchar(15) collate utf8_bin DEFAULT NULL,
  c3 varchar(10) collate utf8_bin DEFAULT NULL,
  spatial_point point NOT NULL,
  PRIMARY KEY(id),
  SPATIAL KEY (spatial_point)
) ROW_FORMAT=$row_format ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES
  ('y', 's', 'j', GeomFromText('POINT(167 74)')),
  ('r', 'n', 'd', GeomFromText('POINT(215 118)')),
  ('g', 'n', 'e', GeomFromText('POINT(203 98)')),
  ('h', 'd', 'd', GeomFromText('POINT(54 193)')),
  ('r', 'x', 'y', GeomFromText('POINT(47 69)')),
  ('t', 'q', 'r', GeomFromText('POINT(109 42)')),
  ('a', 'z', 'd', GeomFromText('POINT(0 154)')),
  ('x', 'v', 'o', GeomFromText('POINT(174 131)')),
  ('b', 'r', 'a', GeomFromText('POINT(114 253)')),
  ('x', 'z', 'i', GeomFromText('POINT(163 21)')),
  ('w', 'p', 'i', GeomFromText('POINT(42 102)')),
  ('g', 'j', 'j', GeomFromText('POINT(170 133)')),
  ('m', 'g', 'n', GeomFromText('POINT(28 22)')),
  ('b', 'z', 'h', GeomFromText('POINT(174 28)')),
  ('q', 'k', 'f', GeomFromText('POINT(233 73)')),
  ('w', 'w', 'a', GeomFromText('POINT(124 200)')),
  ('t', 'j', 'w', GeomFromText('POINT(252 101)')),
  ('d', 'r', 'd', GeomFromText('POINT(98 18)')),
  ('w', 'o', 'y', GeomFromText('POINT(165 31)')),
  ('y', 'h', 't', GeomFromText('POINT(14 220)')),
  ('d', 'p', 'u', GeomFromText('POINT(223 196)')),
  ('g', 'y', 'g', GeomFromText('POINT(207 96)')),
  ('x', 'm', 'n', GeomFromText('POINT(214 3)')),
  ('g', 'v', 'e', GeomFromText('POINT(140 205)')),
  ('g', 'm', 'm', GeomFromText('POINT(10 236)')),
  ('i', 'r', 'j', GeomFromText('POINT(137 228)')),
  ('w', 's', 'p', GeomFromText('POINT(115 6)')),
  ('o', 'n', 'k', GeomFromText('POINT(158 129)')),
  ('j', 'h', 'l', GeomFromText('POINT(129 72)')),
  ('f', 'x', 'l', GeomFromText('POINT(139 207)')),
  ('u', 'd', 'n', GeomFromText('POINT(125 109)')),
  ('b', 'a', 'z', GeomFromText('POINT(30 32)')),
  ('m', 'h', 'o', GeomFromText('POINT(251 251)')),
  ('f', 'r', 'd', GeomFromText('POINT(243 211)')),
  ('b', 'd', 'r', GeomFromText('POINT(232 80)')),
  ('g', 'k', 'v', GeomFromText('POINT(15 100)')),
  ('i', 'f', 'c', GeomFromText('POINT(109 66)')),
  ('r', 't', 'j', GeomFromText('POINT(178 6)')),
  ('y', 'n', 'f', GeomFromText('POINT(233 211)')),
  ('f', 'y', 'm', GeomFromText('POINT(99 16)')),
  ('z', 'q', 'l', GeomFromText('POINT(39 49)')),
  ('j', 'c', 'r', GeomFromText('POINT(75 187)')),
  ('c', 'y', 'y', GeomFromText('POINT(246 253)')),
  ('w', 'u', 'd', GeomFromText('POINT(56 190)')),
  ('n', 'q', 'm', GeomFromText('POINT(73 149)')),
  ('d', 'y', 'a', GeomFromText('POINT(134 6)')),
  ('z', 's', 'w', GeomFromText('POINT(216 225)')),
  ('d', 'u', 'k', GeomFromText('POINT(132 70)')),
  ('f', 'v', 't', GeomFromText('POINT(187 141)')),
  ('r', 'r', 'a', GeomFromText('POINT(152 39)')),
  ('y', 'p', 'o', GeomFromText('POINT(45 27)')),
  ('p', 'n', 'm', GeomFromText('POINT(228 148)')),
  ('e', 'g', 'e', GeomFromText('POINT(88 81)')),
  ('m', 'a', 'h', GeomFromText('POINT(35 29)')),
  ('m', 'h', 'f', GeomFromText('POINT(30 71)')),
  ('h', 'k', 'i', GeomFromText('POINT(244 78)')),
  ('z', 'v', 'd', GeomFromText('POINT(241 38)')),
  ('q', 'l', 'j', GeomFromText('POINT(13 71)')),
  ('s', 'p', 'g', GeomFromText('POINT(108 38)')),
  ('q', 's', 'j', GeomFromText('POINT(92 101)')),
  ('l', 'h', 'g', GeomFromText('POINT(120 78)')),
  ('w', 't', 'b', GeomFromText('POINT(193 109)')),
  ('b', 's', 's', GeomFromText('POINT(223 211)')),
  ('w', 'w', 'y', GeomFromText('POINT(122 42)')),
  ('q', 'c', 'c', GeomFromText('POINT(104 102)')),
  ('w', 'g', 'n', GeomFromText('POINT(213 120)')),
  ('p', 'q', 'a', GeomFromText('POINT(247 148)')),
  ('c', 'z', 'e', GeomFromText('POINT(18 106)')),
  ('z', 'u', 'n', GeomFromText('POINT(70 133)')),
  ('j', 'n', 'x', GeomFromText('POINT(232 13)')),
  ('e', 'h', 'f', GeomFromText('POINT(22 135)')),
  ('w', 'l', 'f', GeomFromText('POINT(9 180)')),
  ('a', 'v', 'q', GeomFromText('POINT(163 228)')),
  ('i', 'z', 'o', GeomFromText('POINT(180 100)')),
  ('e', 'c', 'l', GeomFromText('POINT(182 231)')),
  ('c', 'k', 'o', GeomFromText('POINT(19 60)')),
  ('q', 'f', 'p', GeomFromText('POINT(79 95)')),
  ('m', 'd', 'r', GeomFromText('POINT(3 127)')),
  ('m', 'e', 't', GeomFromText('POINT(136 154)')),
  ('w', 'w', 'w', GeomFromText('POINT(102 15)')),
  ('l', 'n', 'q', GeomFromText('POINT(71 196)')),
  ('p', 'k', 'c', GeomFromText('POINT(47 139)')),
  ('j', 'o', 'r', GeomFromText('POINT(177 128)')),
  ('j', 'q', 'a', GeomFromText('POINT(170 6)')),
  ('b', 'a', 'o', GeomFromText('POINT(63 211)')),
  ('g', 's', 'o', GeomFromText('POINT(144 251)')),
  ('w', 'u', 'w', GeomFromText('POINT(221 214)')),
  ('g', 'a', 'm', GeomFromText('POINT(14 102)')),
  ('u', 'q', 'z', GeomFromText('POINT(86 200)')),
  ('k', 'a', 'm', GeomFromText('POINT(144 222)')),
  ('j', 'u', 'r', GeomFromText('POINT(216 142)')),
  ('q', 'k', 'v', GeomFromText('POINT(121 236)')),
  ('p', 'o', 'r', GeomFromText('POINT(108 102)')),
  ('b', 'd', 'x', GeomFromText('POINT(127 198)')),
  ('k', 's', 'a', GeomFromText('POINT(2 150)')),
  ('f', 'm', 'f', GeomFromText('POINT(160 191)')),
  ('q', 'y', 'x', GeomFromText('POINT(98 111)')),
  ('o', 'f', 'm', GeomFromText('POINT(232 218)')),
  ('c', 'w', 'j', GeomFromText('POINT(156 165)')),
  ('s', 'q', 'v', GeomFromText('POINT(98 161)'));
INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES
  ('f', 'y', 'p', GeomFromText('POINT(109 235)')),
  ('b', 'e', 'v', GeomFromText('POINT(20 48)')),
  ('i', 'u', 'f', GeomFromText('POINT(15 55)')),
  ('o', 'r', 'z', GeomFromText('POINT(105 64)')),
  ('a', 'p', 'a', GeomFromText('POINT(142 236)')),
  ('g', 'i', 'k', GeomFromText('POINT(10 49)')),
  ('x', 'z', 'x', GeomFromText('POINT(192 200)')),
  ('c', 'v', 'r', GeomFromText('POINT(94 168)')),
  ('y', 'z', 'e', GeomFromText('POINT(141 51)')),
  ('h', 'm', 'd', GeomFromText('POINT(35 251)')),
  ('v', 'm', 'q', GeomFromText('POINT(44 90)')),
  ('j', 'l', 'z', GeomFromText('POINT(67 237)')),
  ('i', 'v', 'a', GeomFromText('POINT(75 14)')),
  ('b', 'q', 't', GeomFromText('POINT(153 33)')),
  ('e', 'm', 'a', GeomFromText('POINT(247 49)')),
  ('l', 'y', 'g', GeomFromText('POINT(56 203)')),
  ('v', 'o', 'r', GeomFromText('POINT(90 54)')),
  ('r', 'n', 'd', GeomFromText('POINT(135 83)')),
  ('j', 't', 'u', GeomFromText('POINT(174 239)')),
  ('u', 'n', 'g', GeomFromText('POINT(104 191)')),
  ('p', 'q', 'y', GeomFromText('POINT(63 171)')),
  ('o', 'q', 'p', GeomFromText('POINT(192 103)')),
  ('f', 'x', 'e', GeomFromText('POINT(244 30)')),
  ('n', 'x', 'c', GeomFromText('POINT(92 103)')),
  ('r', 'q', 'z', GeomFromText('POINT(166 20)')),
  ('s', 'a', 'j', GeomFromText('POINT(137 205)')),
  ('z', 't', 't', GeomFromText('POINT(99 134)')),
  ('o', 'm', 'j', GeomFromText('POINT(217 3)')),
  ('n', 'h', 'j', GeomFromText('POINT(211 17)')),
  ('v', 'v', 'a', GeomFromText('POINT(41 137)')),
  ('q', 'o', 'j', GeomFromText('POINT(5 92)')),
  ('z', 'y', 'e', GeomFromText('POINT(175 212)')),
  ('j', 'z', 'h', GeomFromText('POINT(224 194)')),
  ('a', 'g', 'm', GeomFromText('POINT(31 119)')),
  ('p', 'c', 'f', GeomFromText('POINT(17 221)')),
  ('t', 'h', 'k', GeomFromText('POINT(26 203)')),
  ('u', 'w', 'p', GeomFromText('POINT(47 185)')),
  ('z', 'a', 'c', GeomFromText('POINT(61 133)')),
  ('u', 'k', 'a', GeomFromText('POINT(210 115)')),
  ('k', 'f', 'h', GeomFromText('POINT(125 113)')),
  ('t', 'v', 'y', GeomFromText('POINT(12 239)')),
  ('u', 'v', 'd', GeomFromText('POINT(90 24)')),
  ('m', 'y', 'w', GeomFromText('POINT(25 243)')),
  ('d', 'n', 'g', GeomFromText('POINT(122 92)')),
  ('z', 'm', 'f', GeomFromText('POINT(235 110)')),
  ('q', 'd', 'f', GeomFromText('POINT(233 217)')),
  ('a', 'v', 'u', GeomFromText('POINT(69 59)')),
  ('x', 'k', 'p', GeomFromText('POINT(240 14)')),
  ('i', 'v', 'r', GeomFromText('POINT(154 42)')),
  ('w', 'h', 'l', GeomFromText('POINT(178 156)')),
  ('d', 'h', 'n', GeomFromText('POINT(65 157)')),
  ('c', 'k', 'z', GeomFromText('POINT(62 33)')),
  ('e', 'l', 'w', GeomFromText('POINT(162 1)')),
  ('r', 'f', 'i', GeomFromText('POINT(127 71)')),
  ('q', 'm', 'c', GeomFromText('POINT(63 118)')),
  ('c', 'h', 'u', GeomFromText('POINT(205 203)')),
  ('d', 't', 'p', GeomFromText('POINT(234 87)')),
  ('s', 'g', 'h', GeomFromText('POINT(149 34)')),
  ('o', 'b', 'q', GeomFromText('POINT(159 179)')),
  ('k', 'u', 'f', GeomFromText('POINT(202 254)')),
  ('u', 'f', 'g', GeomFromText('POINT(70 15)')),
  ('x', 's', 'b', GeomFromText('POINT(25 181)')),
  ('s', 'c', 'g', GeomFromText('POINT(252 17)')),
  ('a', 'c', 'f', GeomFromText('POINT(89 67)')),
  ('r', 'e', 'q', GeomFromText('POINT(55 54)')),
  ('f', 'i', 'k', GeomFromText('POINT(178 230)')),
  ('p', 'e', 'l', GeomFromText('POINT(198 28)')),
  ('w', 'o', 'd', GeomFromText('POINT(204 189)')),
  ('c', 'a', 'g', GeomFromText('POINT(230 178)')),
  ('r', 'o', 'e', GeomFromText('POINT(61 116)')),
  ('w', 'a', 'a', GeomFromText('POINT(178 237)')),
  ('v', 'd', 'e', GeomFromText('POINT(70 85)')),
  ('k', 'c', 'e', GeomFromText('POINT(147 118)')),
  ('d', 'q', 't', GeomFromText('POINT(218 77)')),
  ('k', 'g', 'f', GeomFromText('POINT(192 113)')),
  ('w', 'n', 'e', GeomFromText('POINT(92 124)')),
  ('r', 'm', 'q', GeomFromText('POINT(130 65)')),
  ('o', 'r', 'r', GeomFromText('POINT(174 233)')),
  ('k', 'n', 't', GeomFromText('POINT(175 147)')),
  ('q', 'm', 'r', GeomFromText('POINT(18 208)')),
  ('l', 'd', 'i', GeomFromText('POINT(13 104)')),
  ('w', 'o', 'y', GeomFromText('POINT(207 39)')),
  ('p', 'u', 'o', GeomFromText('POINT(114 31)')),
  ('y', 'a', 'p', GeomFromText('POINT(106 59)')),
  ('a', 'x', 'z', GeomFromText('POINT(17 57)')),
  ('v', 'h', 'x', GeomFromText('POINT(170 13)')),
  ('t', 's', 'u', GeomFromText('POINT(84 18)')),
  ('z', 'z', 'f', GeomFromText('POINT(250 197)')),
  ('l', 'z', 't', GeomFromText('POINT(59 80)')),
  ('j', 'g', 's', GeomFromText('POINT(54 26)')),
  ('g', 'v', 'm', GeomFromText('POINT(89 98)')),
  ('q', 'v', 'b', GeomFromText('POINT(39 240)')),
  ('x', 'k', 'v', GeomFromText('POINT(246 207)')),
  ('k', 'u', 'i', GeomFromText('POINT(105 111)')),
  ('w', 'z', 's', GeomFromText('POINT(235 8)')),
  ('d', 'd', 'd', GeomFromText('POINT(105 4)')),
  ('c', 'z', 'q', GeomFromText('POINT(13 140)')),
  ('m', 'k', 'i', GeomFromText('POINT(208 120)')),
  ('g', 'a', 'g', GeomFromText('POINT(9 182)')),
  ('z', 'j', 'r', GeomFromText('POINT(149 153)')),
  ('h', 'f', 'g', GeomFromText('POINT(81 236)')),
  ('m', 'e', 'q', GeomFromText('POINT(209 215)')),
  ('c', 'h', 'y', GeomFromText('POINT(235 70)')),
  ('i', 'e', 'g', GeomFromText('POINT(138 26)')),
  ('m', 't', 'u', GeomFromText('POINT(119 237)')),
  ('o', 'w', 's', GeomFromText('POINT(193 166)')),
  ('f', 'm', 'q', GeomFromText('POINT(85 96)')),
  ('x', 'l', 'x', GeomFromText('POINT(58 115)')),
  ('x', 'q', 'u', GeomFromText('POINT(108 210)')),
  ('b', 'h', 'i', GeomFromText('POINT(250 139)')),
  ('y', 'd', 'x', GeomFromText('POINT(199 135)')),
  ('w', 'h', 'p', GeomFromText('POINT(247 233)')),
  ('p', 'z', 't', GeomFromText('POINT(148 249)')),
  ('q', 'a', 'u', GeomFromText('POINT(174 78)')),
  ('v', 't', 'm', GeomFromText('POINT(70 228)')),
  ('t', 'n', 'f', GeomFromText('POINT(123 2)')),
  ('x', 't', 'b', GeomFromText('POINT(35 50)')),
  ('r', 'j', 'f', GeomFromText('POINT(200 51)')),
  ('s', 'q', 'o', GeomFromText('POINT(23 184)')),
  ('u', 'v', 'z', GeomFromText('POINT(7 113)')),
  ('v', 'u', 'l', GeomFromText('POINT(145 190)')),
  ('o', 'k', 'i', GeomFromText('POINT(161 122)')),
  ('l', 'y', 'e', GeomFromText('POINT(17 232)')),
  ('t', 'b', 'e', GeomFromText('POINT(120 50)')),
  ('e', 's', 'u', GeomFromText('POINT(254 1)')),
  ('d', 'd', 'u', GeomFromText('POINT(167 140)')),
  ('o', 'b', 'x', GeomFromText('POINT(186 237)')),
  ('m', 's', 's', GeomFromText('POINT(172 149)')),
  ('t', 'y', 'a', GeomFromText('POINT(149 85)')),
  ('x', 't', 'r', GeomFromText('POINT(10 165)')),
  ('g', 'c', 'e', GeomFromText('POINT(95 165)')),
  ('e', 'e', 'z', GeomFromText('POINT(98 65)')),
  ('f', 'v', 'i', GeomFromText('POINT(149 144)')),
  ('o', 'p', 'm', GeomFromText('POINT(233 67)')),
  ('t', 'u', 'b', GeomFromText('POINT(109 215)')),
  ('o', 'o', 'b', GeomFromText('POINT(130 48)')),
  ('e', 'm', 'h', GeomFromText('POINT(88 189)')),
  ('e', 'v', 'y', GeomFromText('POINT(55 29)')),
  ('e', 't', 'm', GeomFromText('POINT(129 55)')),
  ('p', 'p', 'i', GeomFromText('POINT(126 222)')),
  ('c', 'i', 'c', GeomFromText('POINT(19 158)')),
  ('c', 'b', 's', GeomFromText('POINT(13 19)')),
  ('u', 'y', 'a', GeomFromText('POINT(114 5)')),
  ('a', 'o', 'f', GeomFromText('POINT(227 232)')),
  ('t', 'c', 'z', GeomFromText('POINT(63 62)')),
  ('d', 'o', 'k', GeomFromText('POINT(48 228)')),
  ('x', 'c', 'e', GeomFromText('POINT(204 2)')),
  ('e', 'e', 'g', GeomFromText('POINT(125 43)')),
  ('o', 'r', 'f', GeomFromText('POINT(171 140)'));
INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES
  ('b', 'c', 'e', GeomFromText('POINT(41 137)')),
  ('p', 'y', 'k', GeomFromText('POINT(50 22)')),
  ('s', 'c', 'h', GeomFromText('POINT(208 173)')),
  ('x', 'u', 'l', GeomFromText('POINT(199 175)')),
  ('s', 'r', 'h', GeomFromText('POINT(85 192)')),
  ('j', 'k', 'u', GeomFromText('POINT(18 25)')),
  ('p', 'w', 'h', GeomFromText('POINT(152 197)')),
  ('e', 'd', 'c', GeomFromText('POINT(229 3)')),
  ('o', 'x', 'k', GeomFromText('POINT(187 155)')),
  ('o', 'b', 'k', GeomFromText('POINT(208 150)')),
  ('d', 'a', 'j', GeomFromText('POINT(70 87)')),
  ('f', 'e', 'k', GeomFromText('POINT(156 96)')),
  ('u', 'y', 'p', GeomFromText('POINT(239 193)')),
  ('n', 'v', 'p', GeomFromText('POINT(223 98)')),
  ('z', 'j', 'r', GeomFromText('POINT(87 89)')),
  ('h', 'x', 'x', GeomFromText('POINT(92 0)')),
  ('r', 'v', 'r', GeomFromText('POINT(159 139)')),
  ('v', 'g', 'g', GeomFromText('POINT(16 229)')),
  ('z', 'k', 'u', GeomFromText('POINT(99 52)')),
  ('p', 'p', 'o', GeomFromText('POINT(105 125)')),
  ('w', 'h', 'y', GeomFromText('POINT(105 154)')),
  ('v', 'y', 'z', GeomFromText('POINT(134 238)')),
  ('x', 'o', 'o', GeomFromText('POINT(178 88)')),
  ('z', 'w', 'd', GeomFromText('POINT(123 60)')),
  ('q', 'f', 'u', GeomFromText('POINT(64 90)')),
  ('s', 'n', 't', GeomFromText('POINT(50 138)')),
  ('v', 'p', 't', GeomFromText('POINT(114 91)')),
  ('a', 'o', 'n', GeomFromText('POINT(78 43)')),
  ('k', 'u', 'd', GeomFromText('POINT(185 161)')),
  ('w', 'd', 'n', GeomFromText('POINT(25 92)')),
  ('k', 'w', 'a', GeomFromText('POINT(59 238)')),
  ('t', 'c', 'f', GeomFromText('POINT(65 87)')),
  ('g', 's', 'p', GeomFromText('POINT(238 126)')),
  ('d', 'n', 'y', GeomFromText('POINT(107 173)')),
  ('l', 'a', 'w', GeomFromText('POINT(125 152)')),
  ('m', 'd', 'j', GeomFromText('POINT(146 53)')),
  ('q', 'm', 'c', GeomFromText('POINT(217 187)')),
  ('i', 'r', 'r', GeomFromText('POINT(6 113)')),
  ('e', 'j', 'b', GeomFromText('POINT(37 83)')),
  ('w', 'w', 'h', GeomFromText('POINT(83 199)')),
  ('k', 'b', 's', GeomFromText('POINT(170 64)')),
  ('s', 'b', 'c', GeomFromText('POINT(163 130)')),
  ('c', 'h', 'a', GeomFromText('POINT(141 3)')),
  ('k', 'j', 'u', GeomFromText('POINT(143 76)')),
  ('r', 'h', 'o', GeomFromText('POINT(243 92)')),
  ('i', 'd', 'b', GeomFromText('POINT(205 13)')),
  ('r', 'y', 'q', GeomFromText('POINT(138 8)')),
  ('m', 'o', 'i', GeomFromText('POINT(36 45)')),
  ('v', 'g', 'm', GeomFromText('POINT(0 40)')),
  ('f', 'e', 'i', GeomFromText('POINT(76 6)')),
  ('c', 'q', 'q', GeomFromText('POINT(115 248)')),
  ('x', 'c', 'i', GeomFromText('POINT(29 74)')),
  ('l', 's', 't', GeomFromText('POINT(83 18)')),
  ('t', 't', 'a', GeomFromText('POINT(26 168)')),
  ('u', 'n', 'x', GeomFromText('POINT(200 110)')),
  ('j', 'b', 'd', GeomFromText('POINT(216 136)')),
  ('s', 'p', 'w', GeomFromText('POINT(38 156)')),
  ('f', 'b', 'v', GeomFromText('POINT(29 186)')),
  ('v', 'e', 'r', GeomFromText('POINT(149 40)')),
  ('v', 't', 'm', GeomFromText('POINT(184 24)')),
  ('y', 'g', 'a', GeomFromText('POINT(219 105)')),
  ('s', 'f', 'i', GeomFromText('POINT(114 130)')),
  ('e', 'q', 'h', GeomFromText('POINT(203 135)')),
  ('h', 'g', 'b', GeomFromText('POINT(9 208)')),
  ('o', 'l', 'r', GeomFromText('POINT(245 79)')),
  ('s', 's', 'v', GeomFromText('POINT(238 198)')),
  ('w', 'w', 'z', GeomFromText('POINT(209 232)')),
  ('v', 'd', 'n', GeomFromText('POINT(30 193)')),
  ('q', 'w', 'k', GeomFromText('POINT(133 18)')),
  ('o', 'h', 'o', GeomFromText('POINT(42 140)')),
  ('f', 'f', 'h', GeomFromText('POINT(145 1)')),
  ('u', 's', 'r', GeomFromText('POINT(70 62)')),
  ('x', 'n', 'q', GeomFromText('POINT(33 86)')),
  ('u', 'p', 'v', GeomFromText('POINT(232 220)')),
  ('z', 'e', 'a', GeomFromText('POINT(130 69)')),
  ('r', 'u', 'z', GeomFromText('POINT(243 241)')),
  ('b', 'n', 't', GeomFromText('POINT(120 12)')),
  ('u', 'f', 's', GeomFromText('POINT(190 212)')),
  ('a', 'd', 'q', GeomFromText('POINT(235 191)')),
  ('f', 'q', 'm', GeomFromText('POINT(176 2)')),
  ('n', 'c', 's', GeomFromText('POINT(218 163)')),
  ('e', 'm', 'h', GeomFromText('POINT(163 108)')),
  ('c', 'f', 'l', GeomFromText('POINT(220 115)')),
  ('c', 'v', 'q', GeomFromText('POINT(66 45)')),
  ('w', 'v', 'x', GeomFromText('POINT(251 220)')),
  ('f', 'w', 'z', GeomFromText('POINT(146 149)')),
  ('h', 'n', 'h', GeomFromText('POINT(148 128)')),
  ('y', 'k', 'v', GeomFromText('POINT(28 110)')),
  ('c', 'x', 'q', GeomFromText('POINT(13 13)')),
  ('e', 'd', 's', GeomFromText('POINT(91 190)')),
  ('c', 'w', 'c', GeomFromText('POINT(10 231)')),
  ('u', 'j', 'n', GeomFromText('POINT(250 21)')),
  ('w', 'n', 'x', GeomFromText('POINT(141 69)')),
  ('f', 'p', 'y', GeomFromText('POINT(228 246)')),
  ('d', 'q', 'f', GeomFromText('POINT(194 22)')),
  ('d', 'z', 'l', GeomFromText('POINT(233 181)')),
  ('c', 'a', 'q', GeomFromText('POINT(183 96)')),
  ('m', 'i', 'd', GeomFromText('POINT(117 226)')),
  ('z', 'y', 'y', GeomFromText('POINT(62 81)')),
  ('g', 'v', 'm', GeomFromText('POINT(66 158)'));

START TRANSACTION;

# following INSERTion will result in a node split
INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES
  ('f', 'x', 'p', GeomFromText('POINT(92 181)'));

# Test rollback, this will result above split being rolled back, btr_compress
# gets called
ROLLBACK;

INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES
  ('f', 'x', 'p', GeomFromText('POINT(92 181)'));

# create overlap on the bounding box in parent
INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES  ('n', 'x', 'p', GeomFromText('POINT(0 1280)'));

INSERT INTO t1 (c2, c1, c3, spatial_poINT) VALUES  ('n', 'x', 'p', GeomFromText('POINT(45 1280)'));

# Add a row in the cross section of the 2 bounding box
INSERT INTO t1 VALUES (1280, 'n', 'x', 'p', GeomFromText('POINT(44 253)'));

# Delete this new poINT
DELETE FROM t1 WHERE id = 1280;

INSERT INTO t1 VALUES (1280, 'n', 'x', 'p', GeomFromText('POINT(44 253)'));

START TRANSACTION;
DELETE FROM t1 WHERE id = 1280;
ROLLBACK;

# Test MBR increase
START TRANSACTION;
INSERT INTO t1 (c2, c1, c3, spatial_point) VALUES
  ('m', 'u', 'p', GeomFromText('POINT(1192 1181)'));
ROLLBACK;

SELECT COUNT(*) FROM t1;
UPDATE t1 SET spatial_point = GeomFromText('POINT(123 456)') WHERE id < 2000;
SET @g1 = GeomFromText('Polygon((123 456, 123 678, 456 678,456 456,123 456))');
DELETE FROM t1 WHERE Contains(@g1, t1.spatial_point);
SELECT COUNT(*) FROM t1;

DROP TABLE t1;

SET GLOBAL innodb_file_per_table=default;
SET GLOBAL innodb_file_format=default;

